<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

class Thim_Elementor_Extend_Icons {
	private static $instance = null;

	public function __construct() {
		add_action( 'elementor/editor/before_enqueue_styles', array( $this, 'font_setup' ) );
	}

	public function font_setup() {
		wp_enqueue_style( 'thim-font-icon', THIM_URI . 'assets/css/thim-icons.css' );
		wp_enqueue_style( 'flaticon', THIM_URI . 'assets/css/flaticon.css' );
		wp_enqueue_style( 'font-pe-icon-7', THIM_URI . 'assets/css/font-pe-icon-7.css' );
		wp_enqueue_style( 'ionicons', THIM_URI . 'assets/css/ionicons.min.css' );
	}


	public static function get_instance() {
		if ( self::$instance == null ) {
			self::$instance = new self;
		}

		return self::$instance;
	}
}

Thim_Elementor_Extend_Icons::get_instance();


function thim_register_all_icon_type_ionicons( $icons ) {
	$font_ionicons = array(
		array( 'ion-alert' => 'Alert' ),
		array( 'ion-alert-circled' => 'Alert Circled' ),
		array( 'ion-android-add' => 'Android Add' ),
		array( 'ion-android-add-circle' => 'Android Add Circle' ),
		array( 'ion-android-alarm-clock' => 'Android Alarm Clock' ),
		array( 'ion-android-alert' => 'Android Alert' ),
		array( 'ion-android-apps' => 'Android Apps' ),
		array( 'ion-android-archive' => 'Android Archive' ),
		array( 'ion-android-arrow-back' => 'Android Arrow Back' ),
		array( 'ion-android-arrow-down' => 'Android Arrow Down' ),
		array( 'ion-android-arrow-dropdown' => 'Android Arrow Dropdown' ),
		array( 'ion-android-arrow-dropdown-circle' => 'Android Arrow Dropdown Circle' ),
		array( 'ion-android-arrow-dropleft' => 'Android Arrow Dropleft' ),
		array( 'ion-android-arrow-dropleft-circle' => 'Android Arrow Dropleft Circle' ),
		array( 'ion-android-arrow-dropright' => 'Android Arrow Dropright' ),
		array( 'ion-android-arrow-dropright-circle' => 'Android Arrow Dropright Circle' ),
		array( 'ion-android-arrow-dropup' => 'Android Arrow Dropup' ),
		array( 'ion-android-arrow-dropup-circle' => 'Android Arrow Dropup Circle' ),
		array( 'ion-android-arrow-forward' => 'Android Arrow Forward' ),
		array( 'ion-android-arrow-up' => 'Android Arrow Up' ),
		array( 'ion-android-attach' => 'Android Attach' ),
		array( 'ion-android-bar' => 'Android Bar' ),
		array( 'ion-android-bicycle' => 'Android Bicycle' ),
		array( 'ion-android-boat' => 'Android Boat' ),
		array( 'ion-android-bookmark' => 'Android Bookmark' ),
		array( 'ion-android-bulb' => 'Android Bulb' ),
		array( 'ion-android-bus' => 'Android Bus' ),
		array( 'ion-android-calendar' => 'Android Calendar' ),
		array( 'ion-android-call' => 'Android Call' ),
		array( 'ion-android-camera' => 'Android Camera' ),
		array( 'ion-android-cancel' => 'Android Cancel' ),
		array( 'ion-android-car' => 'Android Car' ),
		array( 'ion-android-cart' => 'Android Cart' ),
		array( 'ion-android-chat' => 'Android Chat' ),
		array( 'ion-android-checkbox' => 'Android Checkbox' ),
		array( 'ion-android-checkbox-blank' => 'Android Checkbox Blank' ),
		array( 'ion-android-checkbox-outline' => 'Android Checkbox Outline' ),
		array( 'ion-android-checkbox-outline-blank' => 'Android Checkbox Outline Blank' ),
		array( 'ion-android-checkmark-circle' => 'Android Checkmark Circle' ),
		array( 'ion-android-clipboard' => 'Android Clipboard' ),
		array( 'ion-android-close' => 'Android Close' ),
		array( 'ion-android-cloud' => 'Android Cloud' ),
		array( 'ion-android-cloud-circle' => 'Android Cloud Circle' ),
		array( 'ion-android-cloud-done' => 'Android Cloud Done' ),
		array( 'ion-android-cloud-outline' => 'Android Cloud Outline' ),
		array( 'ion-android-color-palette' => 'Android Color Palette' ),
		array( 'ion-android-compass' => 'Android Compass' ),
		array( 'ion-android-contact' => 'Android Contact' ),
		array( 'ion-android-contacts' => 'Android Contacts' ),
		array( 'ion-android-contract' => 'Android Contract' ),
		array( 'ion-android-create' => 'Android Create' ),
		array( 'ion-android-delete' => 'Android Delete' ),
		array( 'ion-android-desktop' => 'Android Desktop' ),
		array( 'ion-android-document' => 'Android Document' ),
		array( 'ion-android-done' => 'Android Done' ),
		array( 'ion-android-done-all' => 'Android Done All' ),
		array( 'ion-android-download' => 'Android Download' ),
		array( 'ion-android-drafts' => 'Android Drafts' ),
		array( 'ion-android-exit' => 'Android Exit' ),
		array( 'ion-android-expand' => 'Android Expand' ),
		array( 'ion-android-favorite' => 'Android Favorite' ),
		array( 'ion-android-favorite-outline' => 'Android Favorite Outline' ),
		array( 'ion-android-film' => 'Android Film' ),
		array( 'ion-android-folder' => 'Android Folder' ),
		array( 'ion-android-folder-open' => 'Android Folder Open' ),
		array( 'ion-android-funnel' => 'Android Funnel' ),
		array( 'ion-android-globe' => 'Android Globe' ),
		array( 'ion-android-hand' => 'Android Hand' ),
		array( 'ion-android-hangout' => 'Android Hangout' ),
		array( 'ion-android-happy' => 'Android Happy' ),
		array( 'ion-android-home' => 'Android Home' ),
		array( 'ion-android-image' => 'Android Image' ),
		array( 'ion-android-laptop' => 'Android Laptop' ),
		array( 'ion-android-list' => 'Android List' ),
		array( 'ion-android-locate' => 'Android Locate' ),
		array( 'ion-android-lock' => 'Android Lock' ),
		array( 'ion-android-mail' => 'Android Mail' ),
		array( 'ion-android-map' => 'Android Map' ),
		array( 'ion-android-menu' => 'Android Menu' ),
		array( 'ion-android-microphone' => 'Android Microphone' ),
		array( 'ion-android-microphone-off' => 'Android Microphone Off' ),
		array( 'ion-android-more-horizontal' => 'Android More Horizontal' ),
		array( 'ion-android-more-vertical' => 'Android More Vertical' ),
		array( 'ion-android-navigate' => 'Android Navigate' ),
		array( 'ion-android-notifications' => 'Android Notifications' ),
		array( 'ion-android-notifications-none' => 'Android Notifications None' ),
		array( 'ion-android-notifications-off' => 'Android Notifications Off' ),
		array( 'ion-android-open' => 'Android Open' ),
		array( 'ion-android-options' => 'Android Options' ),
		array( 'ion-android-people' => 'Android People' ),
		array( 'ion-android-person' => 'Android Person' ),
		array( 'ion-android-person-add' => 'Android Person Add' ),
		array( 'ion-android-phone-landscape' => 'Android Phone Landscape' ),
		array( 'ion-android-phone-portrait' => 'Android Phone Portrait' ),
		array( 'ion-android-pin' => 'Android Pin' ),
		array( 'ion-android-plane' => 'Android Plane' ),
		array( 'ion-android-playstore' => 'Android Playstore' ),
		array( 'ion-android-print' => 'Android Print' ),
		array( 'ion-android-radio-button-off' => 'Android Radio Button Off' ),
		array( 'ion-android-radio-button-on' => 'Android Radio Button On' ),
		array( 'ion-android-refresh' => 'Android Refresh' ),
		array( 'ion-android-remove' => 'Android Remove' ),
		array( 'ion-android-remove-circle' => 'Android Remove Circle' ),
		array( 'ion-android-restaurant' => 'Android Restaurant' ),
		array( 'ion-android-sad' => 'Android Sad' ),
		array( 'ion-android-search' => 'Android Search' ),
		array( 'ion-android-send' => 'Android Send' ),
		array( 'ion-android-settings' => 'Android Settings' ),
		array( 'ion-android-share' => 'Android Share' ),
		array( 'ion-android-share-alt' => 'Android Share Alt' ),
		array( 'ion-android-star' => 'Android Star' ),
		array( 'ion-android-star-half' => 'Android Star Half' ),
		array( 'ion-android-star-outline' => 'Android Star Outline' ),
		array( 'ion-android-stopwatch' => 'Android Stopwatch' ),
		array( 'ion-android-subway' => 'Android Subway' ),
		array( 'ion-android-sunny' => 'Android Sunny' ),
		array( 'ion-android-sync' => 'Android Sync' ),
		array( 'ion-android-textsms' => 'Android Textsms' ),
		array( 'ion-android-time' => 'Android Time' ),
		array( 'ion-android-train' => 'Android Train' ),
		array( 'ion-android-unlock' => 'Android Unlock' ),
		array( 'ion-android-upload' => 'Android Upload' ),
		array( 'ion-android-volume-down' => 'Android Volume Down' ),
		array( 'ion-android-volume-mute' => 'Android Volume Mute' ),
		array( 'ion-android-volume-off' => 'Android Volume Off' ),
		array( 'ion-android-volume-up' => 'Android Volume Up' ),
		array( 'ion-android-walk' => 'Android Walk' ),
		array( 'ion-android-warning' => 'Android Warning' ),
		array( 'ion-android-watch' => 'Android Watch' ),
		array( 'ion-android-wifi' => 'Android Wifi' ),
		array( 'ion-aperture' => 'Aperture' ),
		array( 'ion-archive' => 'Archive' ),
		array( 'ion-arrow-down-a' => 'Arrow Down A' ),
		array( 'ion-arrow-down-b' => 'Arrow Down B' ),
		array( 'ion-arrow-down-c' => 'Arrow Down C' ),
		array( 'ion-arrow-expand' => 'Arrow Expand' ),
		array( 'ion-arrow-graph-down-left' => 'Arrow Graph Down Left' ),
		array( 'ion-arrow-graph-down-right' => 'Arrow Graph Down Right' ),
		array( 'ion-arrow-graph-up-left' => 'Arrow Graph Up Left' ),
		array( 'ion-arrow-graph-up-right' => 'Arrow Graph Up Right' ),
		array( 'ion-arrow-left-a' => 'Arrow Left A' ),
		array( 'ion-arrow-left-b' => 'Arrow Left B' ),
		array( 'ion-arrow-left-c' => 'Arrow Left C' ),
		array( 'ion-arrow-move' => 'Arrow Move' ),
		array( 'ion-arrow-resize' => 'Arrow Resize' ),
		array( 'ion-arrow-return-left' => 'Arrow Return Left' ),
		array( 'ion-arrow-return-right' => 'Arrow Return Right' ),
		array( 'ion-arrow-right-a' => 'Arrow Right A' ),
		array( 'ion-arrow-right-b' => 'Arrow Right B' ),
		array( 'ion-arrow-right-c' => 'Arrow Right C' ),
		array( 'ion-arrow-shrink' => 'Arrow Shrink' ),
		array( 'ion-arrow-swap' => 'Arrow Swap' ),
		array( 'ion-arrow-up-a' => 'Arrow Up A' ),
		array( 'ion-arrow-up-b' => 'Arrow Up B' ),
		array( 'ion-arrow-up-c' => 'Arrow Up C' ),
		array( 'ion-asterisk' => 'Asterisk' ),
		array( 'ion-at' => 'At' ),
		array( 'ion-backspace' => 'Backspace' ),
		array( 'ion-backspace-outline' => 'Backspace Outline' ),
		array( 'ion-bag' => 'Bag' ),
		array( 'ion-battery-charging' => 'Battery Charging' ),
		array( 'ion-battery-empty' => 'Battery Empty' ),
		array( 'ion-battery-full' => 'Battery Full' ),
		array( 'ion-battery-half' => 'Battery Half' ),
		array( 'ion-battery-low' => 'Battery Low' ),
		array( 'ion-beaker' => 'Beaker' ),
		array( 'ion-beer' => 'Beer' ),
		array( 'ion-bluetooth' => 'Bluetooth' ),
		array( 'ion-bonfire' => 'Bonfire' ),
		array( 'ion-bookmark' => 'Bookmark' ),
		array( 'ion-bowtie' => 'Bowtie' ),
		array( 'ion-briefcase' => 'Briefcase' ),
		array( 'ion-bug' => 'Bug' ),
		array( 'ion-calculator' => 'Calculator' ),
		array( 'ion-calendar' => 'Calendar' ),
		array( 'ion-camera' => 'Camera' ),
		array( 'ion-card' => 'Card' ),
		array( 'ion-cash' => 'Cash' ),
		array( 'ion-chatbox' => 'Chatbox' ),
		array( 'ion-chatbox-working' => 'Chatbox Working' ),
		array( 'ion-chatboxes' => 'Chatboxes' ),
		array( 'ion-chatbubble' => 'Chatbubble' ),
		array( 'ion-chatbubble-working' => 'Chatbubble Working' ),
		array( 'ion-chatbubbles' => 'Chatbubbles' ),
		array( 'ion-checkmark' => 'Checkmark' ),
		array( 'ion-checkmark-circled' => 'Checkmark Circled' ),
		array( 'ion-checkmark-round' => 'Checkmark Round' ),
		array( 'ion-chevron-down' => 'Chevron Down' ),
		array( 'ion-chevron-left' => 'Chevron Left' ),
		array( 'ion-chevron-right' => 'Chevron Right' ),
		array( 'ion-chevron-up' => 'Chevron Up' ),
		array( 'ion-clipboard' => 'Clipboard' ),
		array( 'ion-clock' => 'Clock' ),
		array( 'ion-close' => 'Close' ),
		array( 'ion-close-circled' => 'Close Circled' ),
		array( 'ion-close-round' => 'Close Round' ),
		array( 'ion-closed-captioning' => 'Closed Captioning' ),
		array( 'ion-cloud' => 'Cloud' ),
		array( 'ion-code' => 'Code' ),
		array( 'ion-code-download' => 'Code Download' ),
		array( 'ion-code-working' => 'Code Working' ),
		array( 'ion-coffee' => 'Coffee' ),
		array( 'ion-compass' => 'Compass' ),
		array( 'ion-compose' => 'Compose' ),
		array( 'ion-connection-bars' => 'Connectbars' ),
		array( 'ion-contrast' => 'Contrast' ),
		array( 'ion-crop' => 'Crop' ),
		array( 'ion-cube' => 'Cube' ),
		array( 'ion-disc' => 'Disc' ),
		array( 'ion-document' => 'Document' ),
		array( 'ion-document-text' => 'Document Text' ),
		array( 'ion-drag' => 'Drag' ),
		array( 'ion-earth' => 'Earth' ),
		array( 'ion-easel' => 'Easel' ),
		array( 'ion-edit' => 'Edit' ),
		array( 'ion-egg' => 'Egg' ),
		array( 'ion-eject' => 'Eject' ),
		array( 'ion-email' => 'Email' ),
		array( 'ion-email-unread' => 'Email Unread' ),
		array( 'ion-erlenmeyer-flask' => 'Erlenmeyer Flask' ),
		array( 'ion-erlenmeyer-flask-bubbles' => 'Erlenmeyer Flask Bubbles' ),
		array( 'ion-eye' => 'Eye' ),
		array( 'ion-eye-disabled' => 'Eye Disabled' ),
		array( 'ion-female' => 'Female' ),
		array( 'ion-filing' => 'Filing' ),
		array( 'ion-film-marker' => 'Film Marker' ),
		array( 'ion-fireball' => 'Fireball' ),
		array( 'ion-flag' => 'Flag' ),
		array( 'ion-flame' => 'Flame' ),
		array( 'ion-flash' => 'Flash' ),
		array( 'ion-flash-off' => 'Flash Off' ),
		array( 'ion-folder' => 'Folder' ),
		array( 'ion-fork' => 'Fork' ),
		array( 'ion-fork-repo' => 'Fork Repo' ),
		array( 'ion-forward' => 'Forward' ),
		array( 'ion-funnel' => 'Funnel' ),
		array( 'ion-gear-a' => 'Gear A' ),
		array( 'ion-gear-b' => 'Gear B' ),
		array( 'ion-grid' => 'Grid' ),
		array( 'ion-hammer' => 'Hammer' ),
		array( 'ion-happy' => 'Happy' ),
		array( 'ion-happy-outline' => 'Happy Outline' ),
		array( 'ion-headphone' => 'Headphone' ),
		array( 'ion-heart' => 'Heart' ),
		array( 'ion-heart-broken' => 'Heart Broken' ),
		array( 'ion-help' => 'Help' ),
		array( 'ion-help-buoy' => 'Help Buoy' ),
		array( 'ion-help-circled' => 'Help Circled' ),
		array( 'ion-home' => 'Home' ),
		array( 'ion-icecream' => 'Icecream' ),
		array( 'ion-image' => 'Image' ),
		array( 'ion-images' => 'Images' ),
		array( 'ion-information' => 'Information' ),
		array( 'ion-information-circled' => 'Informatcircled' ),
		array( 'ion-ionic' => 'Ionic' ),
		array( 'ion-ios-alarm' => 'Ios Alarm' ),
		array( 'ion-ios-alarm-outline' => 'Ios Alarm Outline' ),
		array( 'ion-ios-albums' => 'Ios Albums' ),
		array( 'ion-ios-albums-outline' => 'Ios Albums Outline' ),
		array( 'ion-ios-americanfootball' => 'Ios Americanfootball' ),
		array( 'ion-ios-americanfootball-outline' => 'Ios Americanfootball Outline' ),
		array( 'ion-ios-analytics' => 'Ios Analytics' ),
		array( 'ion-ios-analytics-outline' => 'Ios Analytics Outline' ),
		array( 'ion-ios-arrow-back' => 'Ios Arrow Back' ),
		array( 'ion-ios-arrow-down' => 'Ios Arrow Down' ),
		array( 'ion-ios-arrow-forward' => 'Ios Arrow Forward' ),
		array( 'ion-ios-arrow-left' => 'Ios Arrow Left' ),
		array( 'ion-ios-arrow-right' => 'Ios Arrow Right' ),
		array( 'ion-ios-arrow-thin-down' => 'Ios Arrow Thin Down' ),
		array( 'ion-ios-arrow-thin-left' => 'Ios Arrow Thin Left' ),
		array( 'ion-ios-arrow-thin-right' => 'Ios Arrow Thin Right' ),
		array( 'ion-ios-arrow-thin-up' => 'Ios Arrow Thin Up' ),
		array( 'ion-ios-arrow-up' => 'Ios Arrow Up' ),
		array( 'ion-ios-at' => 'Ios At' ),
		array( 'ion-ios-at-outline' => 'Ios At Outline' ),
		array( 'ion-ios-barcode' => 'Ios Barcode' ),
		array( 'ion-ios-barcode-outline' => 'Ios Barcode Outline' ),
		array( 'ion-ios-baseball' => 'Ios Baseball' ),
		array( 'ion-ios-baseball-outline' => 'Ios Baseball Outline' ),
		array( 'ion-ios-basketball' => 'Ios Basketball' ),
		array( 'ion-ios-basketball-outline' => 'Ios Basketball Outline' ),
		array( 'ion-ios-bell' => 'Ios Bell' ),
		array( 'ion-ios-bell-outline' => 'Ios Bell Outline' ),
		array( 'ion-ios-body' => 'Ios Body' ),
		array( 'ion-ios-body-outline' => 'Ios Body Outline' ),
		array( 'ion-ios-bolt' => 'Ios Bolt' ),
		array( 'ion-ios-bolt-outline' => 'Ios Bolt Outline' ),
		array( 'ion-ios-book' => 'Ios Book' ),
		array( 'ion-ios-book-outline' => 'Ios Book Outline' ),
		array( 'ion-ios-bookmarks' => 'Ios Bookmarks' ),
		array( 'ion-ios-bookmarks-outline' => 'Ios Bookmarks Outline' ),
		array( 'ion-ios-box' => 'Ios Box' ),
		array( 'ion-ios-box-outline' => 'Ios Box Outline' ),
		array( 'ion-ios-briefcase' => 'Ios Briefcase' ),
		array( 'ion-ios-briefcase-outline' => 'Ios Briefcase Outline' ),
		array( 'ion-ios-browsers' => 'Ios Browsers' ),
		array( 'ion-ios-browsers-outline' => 'Ios Browsers Outline' ),
		array( 'ion-ios-calculator' => 'Ios Calculator' ),
		array( 'ion-ios-calculator-outline' => 'Ios Calculator Outline' ),
		array( 'ion-ios-calendar' => 'Ios Calendar' ),
		array( 'ion-ios-calendar-outline' => 'Ios Calendar Outline' ),
		array( 'ion-ios-camera' => 'Ios Camera' ),
		array( 'ion-ios-camera-outline' => 'Ios Camera Outline' ),
		array( 'ion-ios-cart' => 'Ios Cart' ),
		array( 'ion-ios-cart-outline' => 'Ios Cart Outline' ),
		array( 'ion-ios-chatboxes' => 'Ios Chatboxes' ),
		array( 'ion-ios-chatboxes-outline' => 'Ios Chatboxes Outline' ),
		array( 'ion-ios-chatbubble' => 'Ios Chatbubble' ),
		array( 'ion-ios-chatbubble-outline' => 'Ios Chatbubble Outline' ),
		array( 'ion-ios-checkmark' => 'Ios Checkmark' ),
		array( 'ion-ios-checkmark-empty' => 'Ios Checkmark Empty' ),
		array( 'ion-ios-checkmark-outline' => 'Ios Checkmark Outline' ),
		array( 'ion-ios-circle-filled' => 'Ios Circle Filled' ),
		array( 'ion-ios-circle-outline' => 'Ios Circle Outline' ),
		array( 'ion-ios-clock' => 'Ios Clock' ),
		array( 'ion-ios-clock-outline' => 'Ios Clock Outline' ),
		array( 'ion-ios-close' => 'Ios Close' ),
		array( 'ion-ios-close-empty' => 'Ios Close Empty' ),
		array( 'ion-ios-close-outline' => 'Ios Close Outline' ),
		array( 'ion-ios-cloud' => 'Ios Cloud' ),
		array( 'ion-ios-cloud-download' => 'Ios Cloud Download' ),
		array( 'ion-ios-cloud-download-outline' => 'Ios Cloud Download Outline' ),
		array( 'ion-ios-cloud-outline' => 'Ios Cloud Outline' ),
		array( 'ion-ios-cloud-upload' => 'Ios Cloud Upload' ),
		array( 'ion-ios-cloud-upload-outline' => 'Ios Cloud Upload Outline' ),
		array( 'ion-ios-cloudy' => 'Ios Cloudy' ),
		array( 'ion-ios-cloudy-night' => 'Ios Cloudy Night' ),
		array( 'ion-ios-cloudy-night-outline' => 'Ios Cloudy Night Outline' ),
		array( 'ion-ios-cloudy-outline' => 'Ios Cloudy Outline' ),
		array( 'ion-ios-cog' => 'Ios Cog' ),
		array( 'ion-ios-cog-outline' => 'Ios Cog Outline' ),
		array( 'ion-ios-color-filter' => 'Ios Color Filter' ),
		array( 'ion-ios-color-filter-outline' => 'Ios Color Filter Outline' ),
		array( 'ion-ios-color-wand' => 'Ios Color Wand' ),
		array( 'ion-ios-color-wand-outline' => 'Ios Color Wand Outline' ),
		array( 'ion-ios-compose' => 'Ios Compose' ),
		array( 'ion-ios-compose-outline' => 'Ios Compose Outline' ),
		array( 'ion-ios-contact' => 'Ios Contact' ),
		array( 'ion-ios-contact-outline' => 'Ios Contact Outline' ),
		array( 'ion-ios-copy' => 'Ios Copy' ),
		array( 'ion-ios-copy-outline' => 'Ios Copy Outline' ),
		array( 'ion-ios-crop' => 'Ios Crop' ),
		array( 'ion-ios-crop-strong' => 'Ios Crop Strong' ),
		array( 'ion-ios-download' => 'Ios Download' ),
		array( 'ion-ios-download-outline' => 'Ios Download Outline' ),
		array( 'ion-ios-drag' => 'Ios Drag' ),
		array( 'ion-ios-email' => 'Ios Email' ),
		array( 'ion-ios-email-outline' => 'Ios Email Outline' ),
		array( 'ion-ios-eye' => 'Ios Eye' ),
		array( 'ion-ios-eye-outline' => 'Ios Eye Outline' ),
		array( 'ion-ios-fastforward' => 'Ios Fastforward' ),
		array( 'ion-ios-fastforward-outline' => 'Ios Fastforward Outline' ),
		array( 'ion-ios-filing' => 'Ios Filing' ),
		array( 'ion-ios-filing-outline' => 'Ios Filing Outline' ),
		array( 'ion-ios-film' => 'Ios Film' ),
		array( 'ion-ios-film-outline' => 'Ios Film Outline' ),
		array( 'ion-ios-flag' => 'Ios Flag' ),
		array( 'ion-ios-flag-outline' => 'Ios Flag Outline' ),
		array( 'ion-ios-flame' => 'Ios Flame' ),
		array( 'ion-ios-flame-outline' => 'Ios Flame Outline' ),
		array( 'ion-ios-flask' => 'Ios Flask' ),
		array( 'ion-ios-flask-outline' => 'Ios Flask Outline' ),
		array( 'ion-ios-flower' => 'Ios Flower' ),
		array( 'ion-ios-flower-outline' => 'Ios Flower Outline' ),
		array( 'ion-ios-folder' => 'Ios Folder' ),
		array( 'ion-ios-folder-outline' => 'Ios Folder Outline' ),
		array( 'ion-ios-football' => 'Ios Football' ),
		array( 'ion-ios-football-outline' => 'Ios Football Outline' ),
		array( 'ion-ios-game-controller-a' => 'Ios Game Controller A' ),
		array( 'ion-ios-game-controller-a-outline' => 'Ios Game Controller A Outline' ),
		array( 'ion-ios-game-controller-b' => 'Ios Game Controller B' ),
		array( 'ion-ios-game-controller-b-outline' => 'Ios Game Controller B Outline' ),
		array( 'ion-ios-gear' => 'Ios Gear' ),
		array( 'ion-ios-gear-outline' => 'Ios Gear Outline' ),
		array( 'ion-ios-glasses' => 'Ios Glasses' ),
		array( 'ion-ios-glasses-outline' => 'Ios Glasses Outline' ),
		array( 'ion-ios-grid-view' => 'Ios Grid View' ),
		array( 'ion-ios-grid-view-outline' => 'Ios Grid View Outline' ),
		array( 'ion-ios-heart' => 'Ios Heart' ),
		array( 'ion-ios-heart-outline' => 'Ios Heart Outline' ),
		array( 'ion-ios-help' => 'Ios Help' ),
		array( 'ion-ios-help-empty' => 'Ios Help Empty' ),
		array( 'ion-ios-help-outline' => 'Ios Help Outline' ),
		array( 'ion-ios-home' => 'Ios Home' ),
		array( 'ion-ios-home-outline' => 'Ios Home Outline' ),
		array( 'ion-ios-infinite' => 'Ios Infinite' ),
		array( 'ion-ios-infinite-outline' => 'Ios Infinite Outline' ),
		array( 'ion-ios-information' => 'Ios Information' ),
		array( 'ion-ios-information-empty' => 'Ios Informatempty' ),
		array( 'ion-ios-information-outline' => 'Ios Informatoutline' ),
		array( 'ion-ios-ionic-outline' => 'Ios Ionic Outline' ),
		array( 'ion-ios-keypad' => 'Ios Keypad' ),
		array( 'ion-ios-keypad-outline' => 'Ios Keypad Outline' ),
		array( 'ion-ios-lightbulb' => 'Ios Lightbulb' ),
		array( 'ion-ios-lightbulb-outline' => 'Ios Lightbulb Outline' ),
		array( 'ion-ios-list' => 'Ios List' ),
		array( 'ion-ios-list-outline' => 'Ios List Outline' ),
		array( 'ion-ios-location' => 'Ios Location' ),
		array( 'ion-ios-location-outline' => 'Ios Locatoutline' ),
		array( 'ion-ios-locked' => 'Ios Locked' ),
		array( 'ion-ios-locked-outline' => 'Ios Locked Outline' ),
		array( 'ion-ios-loop' => 'Ios Loop' ),
		array( 'ion-ios-loop-strong' => 'Ios Loop Strong' ),
		array( 'ion-ios-medical' => 'Ios Medical' ),
		array( 'ion-ios-medical-outline' => 'Ios Medical Outline' ),
		array( 'ion-ios-medkit' => 'Ios Medkit' ),
		array( 'ion-ios-medkit-outline' => 'Ios Medkit Outline' ),
		array( 'ion-ios-mic' => 'Ios Mic' ),
		array( 'ion-ios-mic-off' => 'Ios Mic Off' ),
		array( 'ion-ios-mic-outline' => 'Ios Mic Outline' ),
		array( 'ion-ios-minus' => 'Ios Minus' ),
		array( 'ion-ios-minus-empty' => 'Ios Minus Empty' ),
		array( 'ion-ios-minus-outline' => 'Ios Minus Outline' ),
		array( 'ion-ios-monitor' => 'Ios Monitor' ),
		array( 'ion-ios-monitor-outline' => 'Ios Monitor Outline' ),
		array( 'ion-ios-moon' => 'Ios Moon' ),
		array( 'ion-ios-moon-outline' => 'Ios Moon Outline' ),
		array( 'ion-ios-more' => 'Ios More' ),
		array( 'ion-ios-more-outline' => 'Ios More Outline' ),
		array( 'ion-ios-musical-note' => 'Ios Musical Note' ),
		array( 'ion-ios-musical-notes' => 'Ios Musical Notes' ),
		array( 'ion-ios-navigate' => 'Ios Navigate' ),
		array( 'ion-ios-navigate-outline' => 'Ios Navigate Outline' ),
		array( 'ion-ios-nutrition' => 'Ios Nutrition' ),
		array( 'ion-ios-nutrition-outline' => 'Ios Nutritoutline' ),
		array( 'ion-ios-paper' => 'Ios Paper' ),
		array( 'ion-ios-paper-outline' => 'Ios Paper Outline' ),
		array( 'ion-ios-paperplane' => 'Ios Paperplane' ),
		array( 'ion-ios-paperplane-outline' => 'Ios Paperplane Outline' ),
		array( 'ion-ios-partlysunny' => 'Ios Partlysunny' ),
		array( 'ion-ios-partlysunny-outline' => 'Ios Partlysunny Outline' ),
		array( 'ion-ios-pause' => 'Ios Pause' ),
		array( 'ion-ios-pause-outline' => 'Ios Pause Outline' ),
		array( 'ion-ios-paw' => 'Ios Paw' ),
		array( 'ion-ios-paw-outline' => 'Ios Paw Outline' ),
		array( 'ion-ios-people' => 'Ios People' ),
		array( 'ion-ios-people-outline' => 'Ios People Outline' ),
		array( 'ion-ios-person' => 'Ios Person' ),
		array( 'ion-ios-person-outline' => 'Ios Person Outline' ),
		array( 'ion-ios-personadd' => 'Ios Personadd' ),
		array( 'ion-ios-personadd-outline' => 'Ios Personadd Outline' ),
		array( 'ion-ios-photos' => 'Ios Photos' ),
		array( 'ion-ios-photos-outline' => 'Ios Photos Outline' ),
		array( 'ion-ios-pie' => 'Ios Pie' ),
		array( 'ion-ios-pie-outline' => 'Ios Pie Outline' ),
		array( 'ion-ios-pint' => 'Ios Pint' ),
		array( 'ion-ios-pint-outline' => 'Ios Pint Outline' ),
		array( 'ion-ios-play' => 'Ios Play' ),
		array( 'ion-ios-play-outline' => 'Ios Play Outline' ),
		array( 'ion-ios-plus' => 'Ios Plus' ),
		array( 'ion-ios-plus-empty' => 'Ios Plus Empty' ),
		array( 'ion-ios-plus-outline' => 'Ios Plus Outline' ),
		array( 'ion-ios-pricetag' => 'Ios Pricetag' ),
		array( 'ion-ios-pricetag-outline' => 'Ios Pricetag Outline' ),
		array( 'ion-ios-pricetags' => 'Ios Pricetags' ),
		array( 'ion-ios-pricetags-outline' => 'Ios Pricetags Outline' ),
		array( 'ion-ios-printer' => 'Ios Printer' ),
		array( 'ion-ios-printer-outline' => 'Ios Printer Outline' ),
		array( 'ion-ios-pulse' => 'Ios Pulse' ),
		array( 'ion-ios-pulse-strong' => 'Ios Pulse Strong' ),
		array( 'ion-ios-rainy' => 'Ios Rainy' ),
		array( 'ion-ios-rainy-outline' => 'Ios Rainy Outline' ),
		array( 'ion-ios-recording' => 'Ios Recording' ),
		array( 'ion-ios-recording-outline' => 'Ios Recording Outline' ),
		array( 'ion-ios-redo' => 'Ios Redo' ),
		array( 'ion-ios-redo-outline' => 'Ios Redo Outline' ),
		array( 'ion-ios-refresh' => 'Ios Refresh' ),
		array( 'ion-ios-refresh-empty' => 'Ios Refresh Empty' ),
		array( 'ion-ios-refresh-outline' => 'Ios Refresh Outline' ),
		array( 'ion-ios-reload' => 'Ios Reload' ),
		array( 'ion-ios-reverse-camera' => 'Ios Reverse Camera' ),
		array( 'ion-ios-reverse-camera-outline' => 'Ios Reverse Camera Outline' ),
		array( 'ion-ios-rewind' => 'Ios Rewind' ),
		array( 'ion-ios-rewind-outline' => 'Ios Rewind Outline' ),
		array( 'ion-ios-rose' => 'Ios Rose' ),
		array( 'ion-ios-rose-outline' => 'Ios Rose Outline' ),
		array( 'ion-ios-search' => 'Ios Search' ),
		array( 'ion-ios-search-strong' => 'Ios Search Strong' ),
		array( 'ion-ios-settings' => 'Ios Settings' ),
		array( 'ion-ios-settings-strong' => 'Ios Settings Strong' ),
		array( 'ion-ios-shuffle' => 'Ios Shuffle' ),
		array( 'ion-ios-shuffle-strong' => 'Ios Shuffle Strong' ),
		array( 'ion-ios-skipbackward' => 'Ios Skipbackward' ),
		array( 'ion-ios-skipbackward-outline' => 'Ios Skipbackward Outline' ),
		array( 'ion-ios-skipforward' => 'Ios Skipforward' ),
		array( 'ion-ios-skipforward-outline' => 'Ios Skipforward Outline' ),
		array( 'ion-ios-snowy' => 'Ios Snowy' ),
		array( 'ion-ios-speedometer' => 'Ios Speedometer' ),
		array( 'ion-ios-speedometer-outline' => 'Ios Speedometer Outline' ),
		array( 'ion-ios-star' => 'Ios Star' ),
		array( 'ion-ios-star-half' => 'Ios Star Half' ),
		array( 'ion-ios-star-outline' => 'Ios Star Outline' ),
		array( 'ion-ios-stopwatch' => 'Ios Stopwatch' ),
		array( 'ion-ios-stopwatch-outline' => 'Ios Stopwatch Outline' ),
		array( 'ion-ios-sunny' => 'Ios Sunny' ),
		array( 'ion-ios-sunny-outline' => 'Ios Sunny Outline' ),
		array( 'ion-ios-telephone' => 'Ios Telephone' ),
		array( 'ion-ios-telephone-outline' => 'Ios Telephone Outline' ),
		array( 'ion-ios-tennisball' => 'Ios Tennisball' ),
		array( 'ion-ios-tennisball-outline' => 'Ios Tennisball Outline' ),
		array( 'ion-ios-thunderstorm' => 'Ios Thunderstorm' ),
		array( 'ion-ios-thunderstorm-outline' => 'Ios Thunderstorm Outline' ),
		array( 'ion-ios-time' => 'Ios Time' ),
		array( 'ion-ios-time-outline' => 'Ios Time Outline' ),
		array( 'ion-ios-timer' => 'Ios Timer' ),
		array( 'ion-ios-timer-outline' => 'Ios Timer Outline' ),
		array( 'ion-ios-toggle' => 'Ios Toggle' ),
		array( 'ion-ios-toggle-outline' => 'Ios Toggle Outline' ),
		array( 'ion-ios-trash' => 'Ios Trash' ),
		array( 'ion-ios-trash-outline' => 'Ios Trash Outline' ),
		array( 'ion-ios-undo' => 'Ios Undo' ),
		array( 'ion-ios-undo-outline' => 'Ios Undo Outline' ),
		array( 'ion-ios-unlocked' => 'Ios Unlocked' ),
		array( 'ion-ios-unlocked-outline' => 'Ios Unlocked Outline' ),
		array( 'ion-ios-upload' => 'Ios Upload' ),
		array( 'ion-ios-upload-outline' => 'Ios Upload Outline' ),
		array( 'ion-ios-videocam' => 'Ios Videocam' ),
		array( 'ion-ios-videocam-outline' => 'Ios Videocam Outline' ),
		array( 'ion-ios-volume-high' => 'Ios Volume High' ),
		array( 'ion-ios-volume-low' => 'Ios Volume Low' ),
		array( 'ion-ios-wineglass' => 'Ios Wineglass' ),
		array( 'ion-ios-wineglass-outline' => 'Ios Wineglass Outline' ),
		array( 'ion-ios-world' => 'Ios World' ),
		array( 'ion-ios-world-outline' => 'Ios World Outline' ),
		array( 'ion-ipad' => 'Ipad' ),
		array( 'ion-iphone' => 'Iphone' ),
		array( 'ion-ipod' => 'Ipod' ),
		array( 'ion-jet' => 'Jet' ),
		array( 'ion-key' => 'Key' ),
		array( 'ion-knife' => 'Knife' ),
		array( 'ion-laptop' => 'Laptop' ),
		array( 'ion-leaf' => 'Leaf' ),
		array( 'ion-levels' => 'Levels' ),
		array( 'ion-lightbulb' => 'Lightbulb' ),
		array( 'ion-link' => 'Link' ),
		array( 'ion-load-a' => 'Load A' ),
		array( 'ion-load-b' => 'Load B' ),
		array( 'ion-load-c' => 'Load C' ),
		array( 'ion-load-d' => 'Load D' ),
		array( 'ion-location' => 'Location' ),
		array( 'ion-lock-combination' => 'Lock Combination' ),
		array( 'ion-locked' => 'Locked' ),
		array( 'ion-log-in' => 'Log In' ),
		array( 'ion-log-out' => 'Log Out' ),
		array( 'ion-loop' => 'Loop' ),
		array( 'ion-magnet' => 'Magnet' ),
		array( 'ion-male' => 'Male' ),
		array( 'ion-man' => 'Man' ),
		array( 'ion-map' => 'Map' ),
		array( 'ion-medkit' => 'Medkit' ),
		array( 'ion-merge' => 'Merge' ),
		array( 'ion-mic-a' => 'Mic A' ),
		array( 'ion-mic-b' => 'Mic B' ),
		array( 'ion-mic-c' => 'Mic C' ),
		array( 'ion-minus' => 'Minus' ),
		array( 'ion-minus-circled' => 'Minus Circled' ),
		array( 'ion-minus-round' => 'Minus Round' ),
		array( 'ion-model-s' => 'Model S' ),
		array( 'ion-monitor' => 'Monitor' ),
		array( 'ion-more' => 'More' ),
		array( 'ion-mouse' => 'Mouse' ),
		array( 'ion-music-note' => 'Music Note' ),
		array( 'ion-navicon' => 'Navicon' ),
		array( 'ion-navicon-round' => 'Navicon Round' ),
		array( 'ion-navigate' => 'Navigate' ),
		array( 'ion-network' => 'Network' ),
		array( 'ion-no-smoking' => 'No Smoking' ),
		array( 'ion-nuclear' => 'Nuclear' ),
		array( 'ion-outlet' => 'Outlet' ),
		array( 'ion-paintbrush' => 'Paintbrush' ),
		array( 'ion-paintbucket' => 'Paintbucket' ),
		array( 'ion-paper-airplane' => 'Paper Airplane' ),
		array( 'ion-paperclip' => 'Paperclip' ),
		array( 'ion-pause' => 'Pause' ),
		array( 'ion-person' => 'Person' ),
		array( 'ion-person-add' => 'Person Add' ),
		array( 'ion-person-stalker' => 'Person Stalker' ),
		array( 'ion-pie-graph' => 'Pie Graph' ),
		array( 'ion-pin' => 'Pin' ),
		array( 'ion-pinpoint' => 'Pinpoint' ),
		array( 'ion-pizza' => 'Pizza' ),
		array( 'ion-plane' => 'Plane' ),
		array( 'ion-planet' => 'Planet' ),
		array( 'ion-play' => 'Play' ),
		array( 'ion-playstation' => 'Playstation' ),
		array( 'ion-plus' => 'Plus' ),
		array( 'ion-plus-circled' => 'Plus Circled' ),
		array( 'ion-plus-round' => 'Plus Round' ),
		array( 'ion-podium' => 'Podium' ),
		array( 'ion-pound' => 'Pound' ),
		array( 'ion-power' => 'Power' ),
		array( 'ion-pricetag' => 'Pricetag' ),
		array( 'ion-pricetags' => 'Pricetags' ),
		array( 'ion-printer' => 'Printer' ),
		array( 'ion-pull-request' => 'Pull Request' ),
		array( 'ion-qr-scanner' => 'Qr Scanner' ),
		array( 'ion-quote' => 'Quote' ),
		array( 'ion-radio-waves' => 'Radio Waves' ),
		array( 'ion-record' => 'Record' ),
		array( 'ion-refresh' => 'Refresh' ),
		array( 'ion-reply' => 'Reply' ),
		array( 'ion-reply-all' => 'Reply All' ),
		array( 'ion-ribbon-a' => 'Ribbon A' ),
		array( 'ion-ribbon-b' => 'Ribbon B' ),
		array( 'ion-sad' => 'Sad' ),
		array( 'ion-sad-outline' => 'Sad Outline' ),
		array( 'ion-scissors' => 'Scissors' ),
		array( 'ion-search' => 'Search' ),
		array( 'ion-settings' => 'Settings' ),
		array( 'ion-share' => 'Share' ),
		array( 'ion-shuffle' => 'Shuffle' ),
		array( 'ion-skip-backward' => 'Skip Backward' ),
		array( 'ion-skip-forward' => 'Skip Forward' ),
		array( 'ion-social-android' => 'Social Android' ),
		array( 'ion-social-android-outline' => 'Social Android Outline' ),
		array( 'ion-social-angular' => 'Social Angular' ),
		array( 'ion-social-angular-outline' => 'Social Angular Outline' ),
		array( 'ion-social-apple' => 'Social Apple' ),
		array( 'ion-social-apple-outline' => 'Social Apple Outline' ),
		array( 'ion-social-bitcoin' => 'Social Bitcoin' ),
		array( 'ion-social-bitcoin-outline' => 'Social Bitcoin Outline' ),
		array( 'ion-social-buffer' => 'Social Buffer' ),
		array( 'ion-social-buffer-outline' => 'Social Buffer Outline' ),
		array( 'ion-social-chrome' => 'Social Chrome' ),
		array( 'ion-social-chrome-outline' => 'Social Chrome Outline' ),
		array( 'ion-social-codepen' => 'Social Codepen' ),
		array( 'ion-social-codepen-outline' => 'Social Codepen Outline' ),
		array( 'ion-social-css3' => 'Social Css3' ),
		array( 'ion-social-css3-outline' => 'Social Css3 Outline' ),
		array( 'ion-social-designernews' => 'Social Designernews' ),
		array( 'ion-social-designernews-outline' => 'Social Designernews Outline' ),
		array( 'ion-social-dribbble' => 'Social Dribbble' ),
		array( 'ion-social-dribbble-outline' => 'Social Dribbble Outline' ),
		array( 'ion-social-dropbox' => 'Social Dropbox' ),
		array( 'ion-social-dropbox-outline' => 'Social Dropbox Outline' ),
		array( 'ion-social-euro' => 'Social Euro' ),
		array( 'ion-social-euro-outline' => 'Social Euro Outline' ),
		array( 'ion-social-facebook' => 'Social Facebook' ),
		array( 'ion-social-facebook-outline' => 'Social Facebook Outline' ),
		array( 'ion-social-foursquare' => 'Social Foursquare' ),
		array( 'ion-social-foursquare-outline' => 'Social Foursquare Outline' ),
		array( 'ion-social-freebsd-devil' => 'Social Freebsd Devil' ),
		array( 'ion-social-github' => 'Social Github' ),
		array( 'ion-social-github-outline' => 'Social Github Outline' ),
		array( 'ion-social-google' => 'Social Google' ),
		array( 'ion-social-google-outline' => 'Social Google Outline' ),
		array( 'ion-social-googleplus' => 'Social Googleplus' ),
		array( 'ion-social-googleplus-outline' => 'Social Googleplus Outline' ),
		array( 'ion-social-hackernews' => 'Social Hackernews' ),
		array( 'ion-social-hackernews-outline' => 'Social Hackernews Outline' ),
		array( 'ion-social-html5' => 'Social Html5' ),
		array( 'ion-social-html5-outline' => 'Social Html5 Outline' ),
		array( 'ion-social-instagram' => 'Social Instagram' ),
		array( 'ion-social-instagram-outline' => 'Social Instagram Outline' ),
		array( 'ion-social-javascript' => 'Social Javascript' ),
		array( 'ion-social-javascript-outline' => 'Social Javascript Outline' ),
		array( 'ion-social-linkedin' => 'Social Linkedin' ),
		array( 'ion-social-linkedin-outline' => 'Social Linkedin Outline' ),
		array( 'ion-social-markdown' => 'Social Markdown' ),
		array( 'ion-social-nodejs' => 'Social Nodejs' ),
		array( 'ion-social-octocat' => 'Social Octocat' ),
		array( 'ion-social-pinterest' => 'Social Pinterest' ),
		array( 'ion-social-pinterest-outline' => 'Social Pinterest Outline' ),
		array( 'ion-social-python' => 'Social Python' ),
		array( 'ion-social-reddit' => 'Social Reddit' ),
		array( 'ion-social-reddit-outline' => 'Social Reddit Outline' ),
		array( 'ion-social-rss' => 'Social Rss' ),
		array( 'ion-social-rss-outline' => 'Social Rss Outline' ),
		array( 'ion-social-sass' => 'Social Sass' ),
		array( 'ion-social-skype' => 'Social Skype' ),
		array( 'ion-social-skype-outline' => 'Social Skype Outline' ),
		array( 'ion-social-snapchat' => 'Social Snapchat' ),
		array( 'ion-social-snapchat-outline' => 'Social Snapchat Outline' ),
		array( 'ion-social-tumblr' => 'Social Tumblr' ),
		array( 'ion-social-tumblr-outline' => 'Social Tumblr Outline' ),
		array( 'ion-social-tux' => 'Social Tux' ),
		array( 'ion-social-twitch' => 'Social Twitch' ),
		array( 'ion-social-twitch-outline' => 'Social Twitch Outline' ),
		array( 'ion-social-twitter' => 'Social Twitter' ),
		array( 'ion-social-twitter-outline' => 'Social Twitter Outline' ),
		array( 'ion-social-usd' => 'Social Usd' ),
		array( 'ion-social-usd-outline' => 'Social Usd Outline' ),
		array( 'ion-social-vimeo' => 'Social Vimeo' ),
		array( 'ion-social-vimeo-outline' => 'Social Vimeo Outline' ),
		array( 'ion-social-whatsapp' => 'Social Whatsapp' ),
		array( 'ion-social-whatsapp-outline' => 'Social Whatsapp Outline' ),
		array( 'ion-social-windows' => 'Social Windows' ),
		array( 'ion-social-windows-outline' => 'Social Windows Outline' ),
		array( 'ion-social-wordpress' => 'Social Wordpress' ),
		array( 'ion-social-wordpress-outline' => 'Social Wordpress Outline' ),
		array( 'ion-social-yahoo' => 'Social Yahoo' ),
		array( 'ion-social-yahoo-outline' => 'Social Yahoo Outline' ),
		array( 'ion-social-yen' => 'Social Yen' ),
		array( 'ion-social-yen-outline' => 'Social Yen Outline' ),
		array( 'ion-social-youtube' => 'Social Youtube' ),
		array( 'ion-social-youtube-outline' => 'Social Youtube Outline' ),
		array( 'ion-soup-can' => 'Soup Can' ),
		array( 'ion-soup-can-outline' => 'Soup Can Outline' ),
		array( 'ion-speakerphone' => 'Speakerphone' ),
		array( 'ion-speedometer' => 'Speedometer' ),
		array( 'ion-spoon' => 'Spoon' ),
		array( 'ion-star' => 'Star' ),
		array( 'ion-stats-bars' => 'Stats Bars' ),
		array( 'ion-steam' => 'Steam' ),
		array( 'ion-stop' => 'Stop' ),
		array( 'ion-thermometer' => 'Thermometer' ),
		array( 'ion-thumbsdown' => 'Thumbsdown' ),
		array( 'ion-thumbsup' => 'Thumbsup' ),
		array( 'ion-toggle' => 'Toggle' ),
		array( 'ion-toggle-filled' => 'Toggle Filled' ),
		array( 'ion-transgender' => 'Transgender' ),
		array( 'ion-trash-a' => 'Trash A' ),
		array( 'ion-trash-b' => 'Trash B' ),
		array( 'ion-trophy' => 'Trophy' ),
		array( 'ion-tshirt' => 'Tshirt' ),
		array( 'ion-tshirt-outline' => 'Tshirt Outline' ),
		array( 'ion-umbrella' => 'Umbrella' ),
		array( 'ion-university' => 'University' ),
		array( 'ion-unlocked' => 'Unlocked' ),
		array( 'ion-upload' => 'Upload' ),
		array( 'ion-usb' => 'Usb' ),
		array( 'ion-videocamera' => 'Videocamera' ),
		array( 'ion-volume-high' => 'Volume High' ),
		array( 'ion-volume-low' => 'Volume Low' ),
		array( 'ion-volume-medium' => 'Volume Medium' ),
		array( 'ion-volume-mute' => 'Volume Mute' ),
		array( 'ion-wand' => 'Wand' ),
		array( 'ion-waterdrop' => 'Waterdrop' ),
		array( 'ion-wifi' => 'Wifi' ),
		array( 'ion-wineglass' => 'Wineglass' ),
		array( 'ion-woman' => 'Woman' ),
		array( 'ion-wrench' => 'Wrench' ),
		array( 'ion-xbox' => 'Xbox' ),
	);

	return array_merge( $icons, $font_ionicons );
}

// add icon  ionicons for VC

add_action( 'vc_backend_editor_enqueue_js_css', 'thim_vc_iconpicker_editor_jscss' );
add_action( 'vc_frontend_editor_enqueue_js_css', 'thim_vc_iconpicker_editor_jscss' );
function thim_vc_iconpicker_editor_jscss() {
	wp_enqueue_style( 'thim-admin-ionicons' );
}

add_filter( 'vc_iconpicker-type-ionicons', 'thim_register_all_icon_type_ionicons' );

//add icon  ionicons for SO
add_filter( 'thim-builder-so-ionicons-icon', 'thim_so_iconpicker_type_ionicons' );
function thim_so_iconpicker_type_ionicons() {
	$arr           = apply_filters( 'vc_iconpicker-type-ionicons', array() );
	$list_new_icon = array();
	if ( ! empty( $arr ) ) {
		foreach ( $arr as $group => $icons ) {
			foreach ( $icons as $key => $label ) {
				$list_new_icon[] = $key;
			}
		}
	}

	return $list_new_icon;
}

// add font for icon ionicons EL
add_filter( 'thim-builder-el-ionicons-icon', 'thim_el_iconpicker_type_ionicons' );
function thim_el_iconpicker_type_ionicons() {
	$arr              = apply_filters( 'vc_iconpicker-type-ionicons', array() );
	$list_new_icon_el = array();
	if ( ! empty( $arr ) ) {
		foreach ( $arr as $group => $icons ) {
			foreach ( $icons as $key => $label ) {
				$list_new_icon_el[$key] = $key;
			}
		}
	}

	return apply_filters( 'thim_list_ionicons', $list_new_icon_el );

}

/// thim_register_all_icon_type_flaticon
function thim_register_all_icon_type_flaticon( $icons ) {
	$font_ionicons = array(
		array( 'flaticon-school-material' => 'school-material' ),
		array( 'flaticon-book' => 'book' ),
		array( 'flaticon-blackboard' => 'blackboard' ),
		array( 'flaticon-mortarboard' => 'mortarboard' ),
		array( 'flaticon-apple' => 'apple' ),
		array( 'flaticon-science-1' => 'science-1' ),
		array( 'flaticon-idea' => 'idea' ),
		array( 'flaticon-books-1' => 'books-1' ),
		array( 'flaticon-pencil-case' => 'pencil-case' ),
		array( 'flaticon-medal' => 'medal' ),
		array( 'flaticon-library' => 'library' ),
		array( 'flaticon-open-book' => 'open-book' ),
		array( 'flaticon-microscope-1' => 'microscope-1' ),
		array( 'flaticon-microscope' => 'microscope' ),
		array( 'flaticon-notebook' => 'notebook' ),
		array( 'flaticon-drawing' => 'drawing' ),
		array( 'flaticon-diploma' => 'diploma' ),
		array( 'flaticon-online' => 'online' ),
		array( 'flaticon-technology-2' => 'technology-2' ),
		array( 'flaticon-internet' => 'internet' ),
		array( 'flaticon-technology-1' => 'technology-1' ),
		array( 'flaticon-school' => 'school' ),
		array( 'flaticon-book-1' => 'book-1' ),
		array( 'flaticon-technology' => 'technology' ),
		array( 'flaticon-education' => 'education' ),
		array( 'flaticon-homework' => 'homework' ),
		array( 'flaticon-code' => 'code' ),
		array( 'flaticon-login' => 'login' ),
		array( 'flaticon-notes' => 'notes' ),
		array( 'flaticon-learning-2' => 'learning-2' ),
		array( 'flaticon-search' => 'search' ),
		array( 'flaticon-learning-1' => 'learning-1' ),
		array( 'flaticon-statistics' => 'statistics' ),
		array( 'flaticon-test' => 'test' ),
		array( 'flaticon-learning' => 'learning' ),
		array( 'flaticon-study' => 'study' ),
		array( 'flaticon-basketball-player' => 'basketball-player' ),
		array( 'flaticon-biology' => 'biology' ),
		array( 'flaticon-students' => 'students' ),
		array( 'flaticon-diploma-1' => 'diploma-1' ),
		array( 'flaticon-books' => 'books' ),
		array( 'flaticon-networking' => 'networking' ),
		array( 'flaticon-teacher' => 'teacher' ),
		array( 'flaticon-graduate' => 'graduate' ),
		array( 'flaticon-reading' => 'reading' ),
		array( 'flaticon-online-learning' => 'online-learning' ),
		array( 'flaticon-innovation' => 'innovation' ),
		array( 'flaticon-research' => 'research' ),
		array( 'flaticon-geography' => 'geography' ),
		array( 'flaticon-science' => 'science' )
	);

	return array_merge( $icons, $font_ionicons );
}

add_filter( 'vc_iconpicker-type-flat_icon', 'thim_register_all_icon_type_flaticon' );
//add icon  ionicons for SO
add_filter( 'thim-builder-so-flat_icon-icon', 'thim_so_iconpicker_type_flat_icon' );
function thim_so_iconpicker_type_flat_icon() {
	$arr           = apply_filters( 'vc_iconpicker-type-flat_icon', array() );
	$list_new_icon = array();
	if ( ! empty( $arr ) ) {
		foreach ( $arr as $group => $icons ) {
			foreach ( $icons as $key => $label ) {
				$list_new_icon[] = str_replace('flaticon-','',$key) ;
			}
		}
	}

	return $list_new_icon;
}

// add font for icon ionicons EL
add_filter( 'thim-builder-el-flat_icon-icon', 'thim_el_iconpicker_type_flat_icon' );
function thim_el_iconpicker_type_flat_icon() {
	$arr              = apply_filters( 'vc_iconpicker-type-flat_icon', array() );
	$list_new_icon_el = array();
	if ( ! empty( $arr ) ) {
		foreach ( $arr as $group => $icons ) {
			foreach ( $icons as $key => $label ) {
				$list_new_icon_el[$key] = $key;
			}
		}
	}

	return apply_filters( 'thim_list_ionicons', $list_new_icon_el );

}

// add icon  ionicons for VC
/// thim_register_all_icon_type_stroke_icon
function thim_register_all_icon_type_stroke_icon( $icons ) {
	$font_icon7 = array(
		array( 'pe-7s-album' => 'pe-7s-album' ),
		array( 'pe-7s-arc' => 'pe-7s-arc' ),
		array( 'pe-7s-back-2' => 'pe-7s-back-2' ),
		array( 'pe-7s-bandaid' => 'pe-7s-bandaid' ),
		array( 'pe-7s-car' => 'pe-7s-car' ),
		array( 'pe-7s-diamond' => 'pe-7s-diamond' ),
		array( 'pe-7s-door-lock' => 'pe-7s-door-lock' ),
		array( 'pe-7s-eyedropper' => 'pe-7s-eyedropper' ),
		array( 'pe-7s-female' => 'pe-7s-female' ),
		array( 'pe-7s-gym' => 'pe-7s-gym' ),
		array( 'pe-7s-hammer' => 'pe-7s-hammer' ),
		array( 'pe-7s-headphones' => 'pe-7s-headphones' ),
		array( 'pe-7s-helm' => 'pe-7s-helm' ),
		array( 'pe-7s-hourglass' => 'pe-7s-hourglass' ),
		array( 'pe-7s-leaf' => 'pe-7s-leaf' ),
		array( 'pe-7s-magic-wand' => 'pe-7s-magic-wand' ),
		array( 'pe-7s-male' => 'pe-7s-male' ),
		array( 'pe-7s-map-2' => 'pe-7s-map-2' ),
		array( 'pe-7s-next-2' => 'pe-7s-next-2' ),
		array( 'pe-7s-paint-bucket' => 'pe-7s-paint-bucket' ),
		array( 'pe-7s-pendrive' => 'pe-7s-pendrive' ),
		array( 'pe-7s-photo' => 'pe-7s-photo' ),
		array( 'pe-7s-piggy' => 'pe-7s-piggy' ),
		array( 'pe-7s-plugin' => 'pe-7s-plugin' ),
		array( 'pe-7s-refresh-2' => 'pe-7s-refresh-2' ),
		array( 'pe-7s-rocket' => 'pe-7s-rocket' ),
		array( 'pe-7s-settings' => 'pe-7s-settings' ),
		array( 'pe-7s-shield' => 'pe-7s-shield' ),
		array( 'pe-7s-smile' => 'pe-7s-smile' ),
		array( 'pe-7s-usb' => 'pe-7s-usb' ),
		array( 'pe-7s-vector' => 'pe-7s-vector' ),
		array( 'pe-7s-wine' => 'pe-7s-wine' ),
		array( 'pe-7s-cloud-upload' => 'pe-7s-cloud-upload' ),
		array( 'pe-7s-cash' => 'pe-7s-cash' ),
		array( 'pe-7s-close' => 'pe-7s-close' ),
		array( 'pe-7s-bluetooth' => 'pe-7s-bluetooth' ),
		array( 'pe-7s-cloud-download' => 'pe-7s-cloud-download' ),
		array( 'pe-7s-way' => 'pe-7s-way' ),
		array( 'pe-7s-close-circle' => 'pe-7s-close-circle' ),
		array( 'pe-7s-id' => 'pe-7s-id' ),
		array( 'pe-7s-angle-up' => 'pe-7s-angle-up' ),
		array( 'pe-7s-wristwatch' => 'pe-7s-wristwatch' ),
		array( 'pe-7s-angle-up-circle' => 'pe-7s-angle-up-circle' ),
		array( 'pe-7s-world' => 'pe-7s-world' ),
		array( 'pe-7s-angle-right' => 'pe-7s-angle-right' ),
		array( 'pe-7s-volume' => 'pe-7s-volume' ),
		array( 'pe-7s-angle-right-circle' => 'pe-7s-angle-right-circle' ),
		array( 'pe-7s-users' => 'pe-7s-users' ),
		array( 'pe-7s-angle-left' => 'pe-7s-angle-left' ),
		array( 'pe-7s-user-female' => 'pe-7s-user-female' ),
		array( 'pe-7s-angle-left-circle' => 'pe-7s-angle-left-circle' ),
		array( 'pe-7s-up-arrow' => 'pe-7s-up-arrow' ),
		array( 'pe-7s-angle-down' => 'pe-7s-angle-down' ),
		array( 'pe-7s-switch' => 'pe-7s-switch' ),
		array( 'pe-7s-angle-down-circle' => 'pe-7s-angle-down-circle' ),
		array( 'pe-7s-scissors' => 'pe-7s-scissors' ),
		array( 'pe-7s-wallet' => 'pe-7s-wallet' ),
		array( 'pe-7s-safe' => 'pe-7s-safe' ),
		array( 'pe-7s-volume2' => 'pe-7s-volume2' ),
		array( 'pe-7s-volume1' => 'pe-7s-volume1' ),
		array( 'pe-7s-voicemail' => 'pe-7s-voicemail' ),
		array( 'pe-7s-video' => 'pe-7s-video' ),
		array( 'pe-7s-user' => 'pe-7s-user' ),
		array( 'pe-7s-upload' => 'pe-7s-upload' ),
		array( 'pe-7s-unlock' => 'pe-7s-unlock' ),
		array( 'pe-7s-umbrella' => 'pe-7s-umbrella' ),
		array( 'pe-7s-trash' => 'pe-7s-trash' ),
		array( 'pe-7s-tools' => 'pe-7s-tools' ),
		array( 'pe-7s-timer' => 'pe-7s-timer' ),
		array( 'pe-7s-ticket' => 'pe-7s-ticket' ),
		array( 'pe-7s-target' => 'pe-7s-target' ),
		array( 'pe-7s-sun' => 'pe-7s-sun' ),
		array( 'pe-7s-study' => 'pe-7s-study' ),
		array( 'pe-7s-stopwatch' => 'pe-7s-stopwatch' ),
		array( 'pe-7s-star' => 'pe-7s-star' ),
		array( 'pe-7s-speaker' => 'pe-7s-speaker' ),
		array( 'pe-7s-signal' => 'pe-7s-signal' ),
		array( 'pe-7s-shuffle' => 'pe-7s-shuffle' ),
		array( 'pe-7s-shopbag' => 'pe-7s-shopbag' ),
		array( 'pe-7s-share' => 'pe-7s-share' ),
		array( 'pe-7s-server' => 'pe-7s-server' ),
		array( 'pe-7s-search' => 'pe-7s-search' ),
		array( 'pe-7s-film' => 'pe-7s-film' ),
		array( 'pe-7s-science' => 'pe-7s-science' ),
		array( 'pe-7s-disk' => 'pe-7s-disk' ),
		array( 'pe-7s-ribbon' => 'pe-7s-ribbon' ),
		array( 'pe-7s-repeat' => 'pe-7s-repeat' ),
		array( 'pe-7s-refresh' => 'pe-7s-refresh' ),
		array( 'pe-7s-add-user' => 'pe-7s-add-user' ),
		array( 'pe-7s-refresh-cloud' => 'pe-7s-refresh-cloud' ),
		array( 'pe-7s-paperclip' => 'pe-7s-paperclip' ),
		array( 'pe-7s-radio' => 'pe-7s-radio' ),
		array( 'pe-7s-note2' => 'pe-7s-note2' ),
		array( 'pe-7s-print' => 'pe-7s-print' ),
		array( 'pe-7s-network' => 'pe-7s-network' ),
		array( 'pe-7s-prev' => 'pe-7s-prev' ),
		array( 'pe-7s-mute' => 'pe-7s-mute' ),
		array( 'pe-7s-power' => 'pe-7s-power' ),
		array( 'pe-7s-medal' => 'pe-7s-medal' ),
		array( 'pe-7s-portfolio' => 'pe-7s-portfolio' ),
		array( 'pe-7s-like2' => 'pe-7s-like2' ),
		array( 'pe-7s-plus' => 'pe-7s-plus' ),
		array( 'pe-7s-left-arrow' => 'pe-7s-left-arrow' ),
		array( 'pe-7s-play' => 'pe-7s-play' ),
		array( 'pe-7s-key' => 'pe-7s-key' ),
		array( 'pe-7s-plane' => 'pe-7s-plane' ),
		array( 'pe-7s-joy' => 'pe-7s-joy' ),
		array( 'pe-7s-photo-gallery' => 'pe-7s-photo-gallery' ),
		array( 'pe-7s-pin' => 'pe-7s-pin' ),
		array( 'pe-7s-phone' => 'pe-7s-phone' ),
		array( 'pe-7s-plug' => 'pe-7s-plug' ),
		array( 'pe-7s-pen' => 'pe-7s-pen' ),
		array( 'pe-7s-right-arrow' => 'pe-7s-right-arrow' ),
		array( 'pe-7s-paper-plane' => 'pe-7s-paper-plane' ),
		array( 'pe-7s-delete-user' => 'pe-7s-delete-user' ),
		array( 'pe-7s-paint' => 'pe-7s-paint' ),
		array( 'pe-7s-bottom-arrow' => 'pe-7s-bottom-arrow' ),
		array( 'pe-7s-notebook' => 'pe-7s-notebook' ),
		array( 'pe-7s-note' => 'pe-7s-note' ),
		array( 'pe-7s-next' => 'pe-7s-next' ),
		array( 'pe-7s-news-paper' => 'pe-7s-news-paper' ),
		array( 'pe-7s-musiclist' => 'pe-7s-musiclist' ),
		array( 'pe-7s-music' => 'pe-7s-music' ),
		array( 'pe-7s-mouse' => 'pe-7s-mouse' ),
		array( 'pe-7s-more' => 'pe-7s-more' ),
		array( 'pe-7s-moon' => 'pe-7s-moon' ),
		array( 'pe-7s-monitor' => 'pe-7s-monitor' ),
		array( 'pe-7s-micro' => 'pe-7s-micro' ),
		array( 'pe-7s-menu' => 'pe-7s-menu' ),
		array( 'pe-7s-map' => 'pe-7s-map' ),
		array( 'pe-7s-map-marker' => 'pe-7s-map-marker' ),
		array( 'pe-7s-mail' => 'pe-7s-mail' ),
		array( 'pe-7s-mail-open' => 'pe-7s-mail-open' ),
		array( 'pe-7s-mail-open-file' => 'pe-7s-mail-open-file' ),
		array( 'pe-7s-magnet' => 'pe-7s-magnet' ),
		array( 'pe-7s-loop' => 'pe-7s-loop' ),
		array( 'pe-7s-look' => 'pe-7s-look' ),
		array( 'pe-7s-lock' => 'pe-7s-lock' ),
		array( 'pe-7s-lintern' => 'pe-7s-lintern' ),
		array( 'pe-7s-link' => 'pe-7s-link' ),
		array( 'pe-7s-like' => 'pe-7s-like' ),
		array( 'pe-7s-light' => 'pe-7s-light' ),
		array( 'pe-7s-less' => 'pe-7s-less' ),
		array( 'pe-7s-keypad' => 'pe-7s-keypad' ),
		array( 'pe-7s-junk' => 'pe-7s-junk' ),
		array( 'pe-7s-info' => 'pe-7s-info' ),
		array( 'pe-7s-home' => 'pe-7s-home' ),
		array( 'pe-7s-help2' => 'pe-7s-help2' ),
		array( 'pe-7s-help1' => 'pe-7s-help1' ),
		array( 'pe-7s-graph3' => 'pe-7s-graph3' ),
		array( 'pe-7s-graph2' => 'pe-7s-graph2' ),
		array( 'pe-7s-graph1' => 'pe-7s-graph1' ),
		array( 'pe-7s-graph' => 'pe-7s-graph' ),
		array( 'pe-7s-global' => 'pe-7s-global' ),
		array( 'pe-7s-gleam' => 'pe-7s-gleam' ),
		array( 'pe-7s-glasses' => 'pe-7s-glasses' ),
		array( 'pe-7s-gift' => 'pe-7s-gift' ),
		array( 'pe-7s-folder' => 'pe-7s-folder' ),
		array( 'pe-7s-flag' => 'pe-7s-flag' ),
		array( 'pe-7s-filter' => 'pe-7s-filter' ),
		array( 'pe-7s-file' => 'pe-7s-file' ),
		array( 'pe-7s-expand1' => 'pe-7s-expand1' ),
		array( 'pe-7s-exapnd2' => 'pe-7s-exapnd2' ),
		array( 'pe-7s-edit' => 'pe-7s-edit' ),
		array( 'pe-7s-drop' => 'pe-7s-drop' ),
		array( 'pe-7s-drawer' => 'pe-7s-drawer' ),
		array( 'pe-7s-download' => 'pe-7s-download' ),
		array( 'pe-7s-display2' => 'pe-7s-display2' ),
		array( 'pe-7s-display1' => 'pe-7s-display1' ),
		array( 'pe-7s-diskette' => 'pe-7s-diskette' ),
		array( 'pe-7s-date' => 'pe-7s-date' ),
		array( 'pe-7s-cup' => 'pe-7s-cup' ),
		array( 'pe-7s-culture' => 'pe-7s-culture' ),
		array( 'pe-7s-crop' => 'pe-7s-crop' ),
		array( 'pe-7s-credit' => 'pe-7s-credit' ),
		array( 'pe-7s-copy-file' => 'pe-7s-copy-file' ),
		array( 'pe-7s-config' => 'pe-7s-config' ),
		array( 'pe-7s-compass' => 'pe-7s-compass' ),
		array( 'pe-7s-comment' => 'pe-7s-comment' ),
		array( 'pe-7s-coffee' => 'pe-7s-coffee' ),
		array( 'pe-7s-cloud' => 'pe-7s-cloud' ),
		array( 'pe-7s-clock' => 'pe-7s-clock' ),
		array( 'pe-7s-check' => 'pe-7s-check' ),
		array( 'pe-7s-chat' => 'pe-7s-chat' ),
		array( 'pe-7s-cart' => 'pe-7s-cart' ),
		array( 'pe-7s-camera' => 'pe-7s-camera' ),
		array( 'pe-7s-call' => 'pe-7s-call' ),
		array( 'pe-7s-calculator' => 'pe-7s-calculator' ),
		array( 'pe-7s-browser' => 'pe-7s-browser' ),
		array( 'pe-7s-box2' => 'pe-7s-box2' ),
		array( 'pe-7s-box1' => 'pe-7s-box1' ),
		array( 'pe-7s-bookmarks' => 'pe-7s-bookmarks' ),
		array( 'pe-7s-bicycle' => 'pe-7s-bicycle' ),
		array( 'pe-7s-bell' => 'pe-7s-bell' ),
		array( 'pe-7s-battery' => 'pe-7s-battery' ),
		array( 'pe-7s-ball' => 'pe-7s-ball' ),
		array( 'pe-7s-back' => 'pe-7s-back' ),
		array( 'pe-7s-attention' => 'pe-7s-attention' ),
		array( 'pe-7s-anchor' => 'pe-7s-anchor' ),
		array( 'pe-7s-albums' => 'pe-7s-albums' ),
		array( 'pe-7s-alarm' => 'pe-7s-alarm' ),
		array( 'pe-7s-airplay' => 'pe-7s-airplay' )
	);

	return array_merge( $icons, $font_icon7 );
}
add_filter( 'vc_iconpicker-type-stroke_icon', 'thim_register_all_icon_type_stroke_icon' );
//add icon  stroke_icon for SO
add_filter( 'thim-builder-so-stroke_icon-icon', 'thim_so_iconpicker_type_stroke_icon' );
function thim_so_iconpicker_type_stroke_icon() {
	$arr           = apply_filters( 'vc_iconpicker-type-stroke_icon', array() );
	$list_new_icon = array();
	if ( ! empty( $arr ) ) {
		foreach ( $arr as $group => $icons ) {
			foreach ( $icons as $key => $label ) {
				$list_new_icon[] = str_replace('pe-7s-','',$key);
			}
		}
	}

	return $list_new_icon;
}

// add font for icon stroke_icon EL
add_filter( 'thim-builder-el-stroke_icon-icon', 'thim_el_iconpicker_type_stroke_icon' );
function thim_el_iconpicker_type_stroke_icon() {
	$arr              = apply_filters( 'vc_iconpicker-type-stroke_icon', array() );
	$list_new_icon_el = array();
	if ( ! empty( $arr ) ) {
		foreach ( $arr as $group => $icons ) {
			foreach ( $icons as $key => $label ) {
				$list_new_icon_el[$key] = $key;
			}
		}
	}

	return apply_filters( 'thim_list_ionicons', $list_new_icon_el );

}
